'''
For this exercise, you can use the following documentation: 
https://docs.python.org/3/library/stdtypes.html#string-methods

# Tuples

A sequence is a data structure that contains items arranged in order, and you 
can access each item using an integer index that represents its position in 
the sequence. You have already encountered strings as an example of a sequence.

A tuple can be used to store multiple items in a single variable. Tuples are 
immutable, meaning that they cannot be changed after they have been defined. 
They are indicated by round brackets: `(item1, item2, ..)`.

In this exercise, we consider a DNA sequence, which is stored as strings. 
Determine the GC-content of the sequence; this is the fraction of the DNA sequence 
made up by G or C bases. The GC-content is important to determine the stability 
of the DNA-molecule. We use the method `.count()` to find how many occurrences 
there are of a specific base in a string.
'''

DNA_sequence = "GTACGAGCATGCTGG"
G_number = DNA_sequence.count("G")
# Extend the code for other bases

'''
Knowing the number of G- and C-bases, we can determine the melting temperature 
of the DNA, i.e., the temperature at which the strands separate from one another, 
using the Wallace rule:
Tm (in C) = 4 * (number of Gs + number of Cs) + 2 * (number of As + number of Ts)
Calculate the melting temperature of the DNA sequence.
'''

melting_temperature =  # add your code here
print(f"The melting temperature is {melting_temperature} degrees Celsius")

'''
Store the variables with information on the DNA (melting temperature, GC content) 
in a tuple to have all of it in one place:
'''

sequence_information = (.., ..)

'''
Run the following code to check whether your `sequence_information` is correct:
'''

from check_08 import *
check_08(DNA_sequence, sequence_information)

''' 
Imagine we want to raise the melting temperature and increase the stability.
To do so, we would have to increase the GC-content. Add 4 G or C bases to 
the original string and calculate the new melting temperature.
'''

new_DNA_sequence =
new_melting_temperature =

'''
Index the tuple `sequence_information` to retrieve the `melting_temperature` 
of the initial strand. By how much did the melting temperature increase?
'''

# Your code here